varying vec2 		texcoord;	
uniform sampler2D 	tex,maskTex;
varying float		distance;

#ifdef TRANSFORM

varying vec3		tc3;
	
#endif

void main()
{

	// compute diffuse lighting
	vec4 Channels=texture2D(maskTex,texcoord.st);

#ifdef TRANSFORM
	vec4 decal=texture2D(tex,tc3.st);
#else
	vec4 decal=texture2D(tex,texcoord.st);
#endif

	float d=clamp(distance,0.0,10000.0);
	d/=10000.0;

	float color=dot(Channels,decal)+d;
	
	// output color
	gl_FragColor=vec4(color,color,color,color);
}